/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.Authenticator;
import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.connmgr.InvalidPasswordException;
import com.ibm.hwmca.fw.logon.LogonValidation;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;

public class HMCLocalAuthenticator
extends Authenticator
implements ConnectionConstants {
    public static final String THIS_CLASS = "HMCLocalAuthenticator";
    public static final String PROTOCOL_VERSION = new String("HMC 1.00");
    private String _userName = null;
    private UserContext _context = null;

    public HMCLocalAuthenticator(Socket socket) throws IOException {
        super(socket);
        if (!socket.getInetAddress().isLoopbackAddress()) {
            throw new RuntimeException("A non-local client attempted to authenticate on a local only connection.");
        }
    }

    public String getUserName() {
        return this._userName;
    }

    public UserContext getContext() {
        return this._context;
    }

    public boolean verifyContext(ContextId contextId) throws HException, IOException {
        Trace.trace("HSSLCONF", "--> HMCLocalAuthenticator.verifyContext:  for context " + contextId);
        boolean result = this.verifyConnectionToServer(contextId.getBytes(), ConnectionConstants.CONTEXT_PASSWORD, true);
        Trace.trace("HSSLCONF", "<-- HMCLocalAuthenticator.verifyContext:  returning " + result);
        return result;
    }

    public boolean verifyUseridAndPassword(String userid, byte[] password) throws HException, IOException {
        Trace.trace("HSSLCONF", "--> HMCLocalAuthenticator.verifyUseridAndPassword:  for " + userid);
        this._userName = userid;
        boolean result = this.verifyConnectionToServer(userid.getBytes("UTF-8"), password, false);
        Trace.trace("HSSLCONF", "<-- HMCLocalAuthenticator.verifyUseridAndPassword:  returning " + result);
        return result;
    }

    public boolean verifyConnectionToServer(byte[] userToken, byte[] password, boolean contextVerify) throws IOException {
        Trace.trace("HSSLCONF", "--> HMCLocalAuthenticator.verifyConnectionToServer:");
        this.output = new DataOutputStream(this.socket.getOutputStream());
        this.input = new DataInputStream(this.socket.getInputStream());
        String protocol = this.input.readUTF();
        if (!protocol.equals(PROTOCOL_VERSION)) {
            this.output.writeBoolean(false);
            throw new IllegalStateException("Invalid authentication protocol:  " + protocol);
        }
        this.output.writeBoolean(true);
        this.writeByteArray(userToken);
        Trace.trace("HSSLCONF", "HMCLocalAuthenticator.verifyConnectionToServer:  wrote context ");
        this.output.flush();
        this.writeByteArray(password);
        Trace.trace("HSSLCONF", "HMCLocalAuthenticator.verifyConnectionToServer:  wrote password ");
        this.output.flush();
        Trace.trace("HSSLCONF", "HMCLocalAuthenticator.verifyConnectionToServer:  flushed output");
        this.output.writeBoolean(contextVerify);
        Trace.trace("HSSLCONF", "HMCLocalAuthenticator.verifyConnectionToServer:  wrote context verify = " + contextVerify);
        this.output.flush();
        boolean result = this.input.readBoolean();
        Trace.trace("HSSLCONF", "<-- HMCLocalAuthenticator.verifyConnectionToServer:  returning " + result);
        return result;
    }

    public boolean authenticateClient(Authenticator.GateKeeper gateKeeper, Authenticator.ContextKeeper contextManager) throws HException, IOException, InvalidPasswordException {
        Trace.trace("HSSLCONT", "--> HMCLocalAuthenticator.java.authenticateClient:  ");
        this.output = new DataOutputStream(this.socket.getOutputStream());
        this.input = new DataInputStream(this.socket.getInputStream());
        this.output.writeUTF(PROTOCOL_VERSION);
        boolean protocolOK = this.input.readBoolean();
        if (!protocolOK) {
            throw new IllegalStateException("Client is not prepared to handle:  " + PROTOCOL_VERSION);
        }
        byte[] userToken = this.readByteArray();
        Trace.trace("HSSLCONF", "HMCLocalAuthenticator.authenticateClient:  read user or context");
        byte[] clientPassword = this.readByteArray();
        Trace.trace("HSSLCONF", "HMCLocalAuthenticator.authenticateClient:  read password ");
        boolean contextVerify = this.input.readBoolean();
        Trace.trace("HSSLCONF", "HMCLocalAuthenticator.authenticateClient:  read contextVerify = " + contextVerify);
        byte[] serverPassword = null;
        if (contextVerify) {
            this._context = contextManager.getContext(new ContextId(userToken));
            if (this._context != null) {
                this._userName = this._context.getUserid();
                if (this._userName != null) {
                    serverPassword = ConnectionConstants.CONTEXT_PASSWORD;
                    Trace.trace("HSSLCONF", "HMCLocalAuthenticator.authenticateClient:  set context password for found context for " + this._userName);
                }
            }
        } else {
            this._userName = new String(userToken, "UTF-8");
            serverPassword = gateKeeper.getPassword(this._userName);
            Trace.trace("HSSLCONF", "HMCLocalAuthenticator.authenticateClient:  found a password for user " + this._userName);
        }
        if (serverPassword == null || !Arrays.equals(serverPassword, clientPassword)) {
            if (serverPassword == null) {
                Trace.trace("HSSLCOND", "HMCLocalAuthenticator.authenticateClient:  didn't find a user named " + this._userName);
            } else {
                Trace.trace("HSSLCOND", "HMCLocalAuthenticator.authenticateClient:  passwords didn't match");
            }
            Trace.trace("HSSLCOND", "HMCLocalAuthenticator.authenticateClient:  password check failed for " + this._userName);
            if (!contextVerify && this._userName != null && !this._userName.equals("logonuser")) {
                LogonValidation.GATE_KEEPER.recordFailedLogonAttempt(this._userName);
            }
            this.output.writeBoolean(false);
            Trace.trace("HSSLCONF", "HMCLocalAuthenticator.authenticateClient:  wrote false, client verify failed");
            this.output.flush();
            throw new InvalidPasswordException(this._userName);
        }
        if (!contextVerify && this._userName != null && !this._userName.equals("logonuser")) {
            LogonValidation.GATE_KEEPER.recordSuccessfulLogonAttempt(this._userName);
        }
        this.output.writeBoolean(true);
        Trace.trace("HSSLCONF", "HMCLocalAuthenticator.authenticateClient:  wrote true, client verify succeeded");
        this.output.flush();
        Trace.trace("HSSLCONF", "<-- HMCLocalAuthenticator.authenticateClient:  returning " + this._userName);
        return true;
    }
}

